/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ItemSearcherMenu;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ItemSearcherScreen
extends AbstractContainerScreen<ItemSearcherMenu> {
    private static final ResourceLocation GUI_TEXTURE = Textures.GUI_ITEM_SEARCHER;
    private static final ResourceLocation SCROLL_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SEARCH_SLOT = 48;
    private static List<SearchEntry> cachedSearchEntries;
    private final ItemStackHandler inventory = new ItemStackHandler(49);
    private final Screen parentScreen;
    private double currentScroll;
    private boolean isScrolling;
    private EditBox searchField;
    private Rect2i scrollArea;
    private String lastSearch = "";
    private int updateCounter = 0;

    public ItemSearcherScreen(ItemSearcherMenu container, Inventory playerInventory, Component displayString) {
        super((AbstractContainerMenu)container, playerInventory, displayString);
        this.f_96546_ = true;
        this.f_97727_ = 176;
        this.parentScreen = Minecraft.m_91087_().f_91080_;
        container.init(this);
    }

    public boolean m_6913_() {
        return true;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(48);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(48, stack);
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            if (slot.f_40219_ == 48) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                this.inventory.setStackInSlot(48, slot.m_7993_());
            }
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        Objects.requireNonNull(this.f_96547_);
        this.searchField = new WidgetTextField(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 36, 89, 9);
        this.searchField.m_94199_(15);
        this.searchField.m_94182_(true);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94151_(s -> this.textFieldResponder());
        this.m_142416_((GuiEventListener)this.searchField);
        this.m_7522_((GuiEventListener)this.searchField);
        this.searchField.m_94178_(true);
        this.scrollArea = new Rect2i(this.f_97735_ + 156, this.f_97736_ + 48, 14, 112);
        this.updateCreativeSearch();
    }

    private void textFieldResponder() {
        if (!this.searchField.m_94155_().equals(this.lastSearch)) {
            this.updateCounter = 5;
        }
        this.lastSearch = this.searchField.m_94155_();
    }

    public void m_7379_() {
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.parentScreen != null) {
            ClientUtils.closeContainerGui(this.parentScreen);
        } else {
            super.m_7379_();
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.updateCounter > 0 && --this.updateCounter == 0) {
            this.updateCreativeSearch();
        }
        if (this.parentScreen instanceof ArmorMainScreen && this.f_96541_.f_91074_.m_6844_(EquipmentSlot.HEAD).m_41720_() != ModItems.PNEUMATIC_HELMET.get()) {
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
        }
        return !this.searchField.m_7933_(keyCode, scanCode, modifiers) && this.searchField.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void getAllEnchantedBooks(Enchantment enchantment, NonNullList<ItemStack> list) {
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            list.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
        }
    }

    private Stream<SearchEntry> getSearchEntries() {
        if (cachedSearchEntries == null) {
            NonNullList itemList = NonNullList.m_122779_();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                NonNullList l = NonNullList.m_122779_();
                if (item != null && item.m_41471_() != null) {
                    item.m_6787_(item.m_41471_(), l);
                }
                itemList.addAll((Collection)l);
            }
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
                if (enchantment == null || enchantment.f_44672_ == null) continue;
                this.getAllEnchantedBooks(enchantment, (NonNullList<ItemStack>)itemList);
            }
            cachedSearchEntries = itemList.stream().map(x$0 -> new SearchEntry((ItemStack)x$0)).collect(Collectors.toList());
        }
        return cachedSearchEntries.stream();
    }

    private void updateCreativeSearch() {
        ((ItemSearcherMenu)this.f_97732_).itemList.clear();
        String s = this.searchField.m_94155_().toLowerCase();
        List<ItemStack> applicableEntries = this.getSearchEntries().filter(entry -> entry.test(s)).map(entry -> entry.stack).toList();
        ((ItemSearcherMenu)this.f_97732_).itemList.addAll(applicableEntries);
        this.currentScroll = 0.0;
        ((ItemSearcherMenu)this.f_97732_).scrollTo(0.0);
    }

    private boolean needsScrollBars() {
        return ((ItemSearcherMenu)this.f_97732_).hasMoreThan1PageOfItemsInList();
    }

    public boolean m_6050_(double x, double y, double dir) {
        if (dir != 0.0 && this.needsScrollBars()) {
            int j = ((ItemSearcherMenu)this.f_97732_).itemList.size() / 9 - 5 + 1;
            float i = dir > 0.0 ? 1.0f : -1.0f;
            this.currentScroll = Mth.m_14008_((double)(this.currentScroll - (double)(i / (float)j)), (double)0.0, (double)1.0);
            ((ItemSearcherMenu)this.f_97732_).scrollTo(this.currentScroll);
            return true;
        }
        return super.m_6050_(x, y, dir);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl = this.isScrolling = button == 0 && this.needsScrollBars() && this.scrollArea.m_110087_((int)mouseX, (int)mouseY);
        if (this.isScrolling) {
            this.scrollTo(mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollTo(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void scrollTo(double mouseY) {
        this.currentScroll = (mouseY - (double)this.scrollArea.m_110086_()) / (double)this.scrollArea.m_110091_();
        this.currentScroll = Mth.m_14008_((double)this.currentScroll, (double)0.0, (double)1.0);
        ((ItemSearcherMenu)this.f_97732_).scrollTo(this.currentScroll);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTicks);
        this.m_7025_(matrixStack, x, y);
    }

    protected void m_7027_(PoseStack matrixStack, int par1, int par2) {
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)"pneumaticcraft.armor.upgrade.search", (Object[])new Object[0]), 5.0f, 5.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)"pneumaticcraft.gui.progWidget.itemFilter.filterLabel", (Object[])new Object[0]), 8.0f, 25.0f, 0x404040);
    }

    protected void m_7286_(PoseStack matrixStack, float par1, int par2, int par3) {
        GuiUtils.bindTexture(GUI_TEXTURE);
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, xStart, yStart, 0, 0, this.f_97726_, this.f_97727_);
        int x = this.scrollArea.m_110085_();
        int y1 = this.scrollArea.m_110086_();
        int y2 = y1 + this.scrollArea.m_110091_();
        GuiUtils.bindTexture(SCROLL_TEXTURE);
        this.m_93228_(matrixStack, x, y1 + (int)((double)(y2 - y1 - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public class SearchEntry
    implements Predicate<String> {
        public final ItemStack stack;
        private final String tooltip;

        SearchEntry(ItemStack stack) {
            List l;
            this.stack = stack;
            try {
                l = stack.m_41651_((Player)((ItemSearcherScreen)ItemSearcherScreen.this).f_96541_.f_91074_, (TooltipFlag)(((ItemSearcherScreen)ItemSearcherScreen.this).f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)).stream().map(Component::getString).collect(Collectors.toList());
            }
            catch (Exception ignored) {
                l = Collections.emptyList();
            }
            this.tooltip = StringUtils.join(l, (String)"\n").toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

